﻿using System;
using System.Collections.Generic;
using Amplitude.AI.Common;
using Amplitude.AI.Core.Brain.Tasks;
using Amplitude.AI.Core.Decision.ProcessingPasses;
using Amplitude.AI.Core.Framework.Debug;
using Amplitude.AI.Core.Services;
using Amplitude.AI.Core.Snapshots;
using Amplitude.AI.Core.Snapshots.EntitySnapshots.GroundBattle;

namespace Amplitude.AI.Core.Brain.Generators.Encounter
{
    public class ReplayGroundBattleSolver : DefaultRootGenerator<GroundBattleSnapshot, GroundBattleReplayTask>
    {
        public override string Description
        {
            get
            {
                return "Push notification to finish a replayable battle.";
            }
        }

        public override int EvaluationPriority
        {
            get
            {
                return 10;
            }
        }

        public override string LocalizedName
        {
            get
            {
                return "Finish a replayable battle";
            }
        }

        public override AIPlayerExecutionMode MinimumRequiredExecutionMode
        {
            get
            {
                return AIPlayerExecutionMode.Full;
            }
        }

        protected override void GenerateDecision(AIPlayer aiPlayer, GroundBattleSnapshot context)
        {
            GroundBattleReplayTask groundBattleFinishTask = aiPlayer.Blackboard.FindFirstRunning<GroundBattleReplayTask>(context.GameEntityGuid);
            if (groundBattleFinishTask == null)
            {
                groundBattleFinishTask = new GroundBattleReplayTask(aiPlayer.Blackboard.GenerateGUID(), context.GameEntityGuid);
                aiPlayer.Blackboard.Register<GroundBattleReplayTask>(groundBattleFinishTask);
            }
            base.ContinueDecision(aiPlayer, base.GetGenerationData(context, groundBattleFinishTask));
        }

        protected override void GetContexts(AIPlayer aiPlayer)
        {
            List<EntitySnapshot> entitySnapshots = Amplitude.AI.Core.Framework.Services.GetService<ISnapshotRepositoryService>().GetEntitySnapshots(typeof(GroundBattleSnapshot));
            for (int i = 0; i < entitySnapshots.Count; i++)
            {
                GroundBattleSnapshot groundBattleSnapshot = entitySnapshots[i] as GroundBattleSnapshot;
                if (groundBattleSnapshot != null && groundBattleSnapshot.AttackerEmpireGuid == aiPlayer.ControlledEmpireSnapshot.GameEntityGuid && groundBattleSnapshot.CanBeReplayed && groundBattleSnapshot.IsFinished)
                {
                    base.ContinueDecision(aiPlayer, groundBattleSnapshot);
                }
            }
        }

        protected override HeuristicFloat ComputeLocalMotivation(AIPlayer aiPlayer, GenerationData<GroundBattleSnapshot, GroundBattleReplayTask> taskContext)
        {
            return new HeuristicFloat(1f, "Base Motivation");
        }

        public ReplayGroundBattleSolver()
        {
        }
    }
}
