﻿using System;
using Amplitude.AI.Common.IO.Contract.Attributes;

namespace Amplitude.AI.Core.Snapshots.EntitySnapshots.GroundBattle
{
	[SnapshotType("GroundBattle")]
	public class GroundBattleSnapshot : EntitySnapshot
	{
		[HeaderProperty]
		public GroundBattleReport BattleReport { get; private set; }

		[HeaderProperty("AttackerEmpire")]
		[ClassProperty("GUID")]
		public ulong AttackerEmpireGuid { get; set; }

		[ClassField("displayedAttackerEmpireGUID")]
		public ulong DisplayedAttackerEmpireGuid { get; set; }

		[HeaderProperty("DefenderEmpire")]
		[ClassProperty("GUID")]
		public ulong DefenderEmpireGuid { get; set; }

		[HeaderProperty("DefenderNode")]
		[ClassProperty("GUID")]
		public ulong DefenderNode { get; set; }

		[HeaderProperty("SpawnReport")]
		[ClassProperty("AttackerInitManPower")]
		public float AttackerManpower { get; set; }

		[HeaderProperty("SpawnReport")]
		[ClassProperty("AttackerTotalManPower")]
		public float AttackerTotalManPower { get; set; }

		[ArrayMethod("GetAttackerStrategies")]
		public string[] AttackerStrategies { get; set; }

		[HeaderProperty("SpawnReport")]
		[ClassProperty("DefenderInitManPower")]
		public float DefenderManpower { get; set; }

		[HeaderProperty("SpawnReport")]
		[ClassProperty("DefenderTotalManPower")]
		public float DefenderTotalManPower { get; set; }

		[ArrayMethod("GetDefenderStrategies")]
		public string[] DefenderStrategies { get; set; }

		[ClassProperty]
		public bool IsAttackerStrategySet { get; private set; }

		[ClassProperty]
		public bool IsDefenderStrategySet { get; private set; }

		[ClassProperty]
		public ulong DefenderColonizedStarSystemGUID { get; set; }

		[ClassProperty]
		public bool CanBeReplayed { get; set; }

        [HeaderProperty("ReplayEmpire")]
        [ClassProperty("GUID")]
        public ulong ReplayEmpireGUID { get; set; }

        public int RoundsCount
		{
			get
			{
				if (this.BattleReport == null)
				{
					return -1;
				}
				return this.BattleReport.RoundsCount;
			}
		}

		[ClassMethod]
		public bool HasBeenComputedForThisTurn { get; private set; }

		public bool IsFinished
		{
			get
			{
				return this.BattleReport != null && this.BattleReport.IsFinished;
			}
		}

		[ArrayMethod("GetValidOutcomes")]
		public string[] ValidOutcomes { get; set; }

		public override bool NeedSync()
		{
			return true;
		}

		public override void AfterSynchronize()
		{
			base.AfterSynchronize();
		}
	}
}
