﻿using System;
using Amplitude.AI.Core.Brain.Actuators;
using Amplitude.AI.Core.Collections.Blackboard;
using Amplitude.AI.Core.Decision;
using Amplitude.AI.Core.Framework.Serialization;

namespace Amplitude.AI.Core.Brain.Tasks
{
	public class GroundBattleReplayTask : Task
	{
		public GroundBattleReplayTask()
		{
            this.ReplayRefused = true;
        }

		public GroundBattleReplayTask(BlackboardGuid guid, ulong groundBattleGuid) : base(guid)
		{
			base.ContextGuid = groundBattleGuid;
		}

		public override Type ActuatorType
		{
			get
			{
				return typeof(GroundBattleReplayActuator);
			}
		}

		public bool ReplayRefused { get; set; }

		public override string LocalizedName
		{
			get
			{
				return string.Format("Finish Replay Ground battle {0}", base.ContextGuid);
			}
		}

		public override void SerializeAttributes(IAttributesSerializer serializer, IVersionProvider versionProvider)
		{
			base.SerializeAttributes(serializer, versionProvider);
			base.ContextGuid = serializer.SerializeAttribute<ulong>("GroundBattleGuid", base.ContextGuid);
			this.ReplayRefused = serializer.SerializeAttribute<bool>("ReplayRefused", this.ReplayRefused);
        }
	}
}
