﻿using System;
using Amplitude.AI.Common.IO.Messages;
using Amplitude.AI.Common.Threading;
using Amplitude.AI.Core.Brain.Tasks;
using Amplitude.AI.Core.Decision;

namespace Amplitude.AI.Core.Brain.Actuators
{
	public class GroundBattleReplayActuator : OrderActuator
	{
		public override void Initialize(AIPlayer aiPlayer, Task task)
		{
			base.Initialize(aiPlayer, task);
			this.task = (base.Task as GroundBattleReplayTask);
			if (this.task == null)
			{
				throw new Exception(string.Format("Invalid task type: {0}.", base.Task.GetType().Name));
			}
		}

		public override ActionMessage CreateOrderMessage(AIPlayer aiPlayer)
		{
			return base.PoolService.GetOrderMessage(aiPlayer.ControlledEmpireSnapshot.EmpireIndex, "GameClient/OrderReplayGroundBattle", new object[]
			{
				this.task.ContextGuid,
                this.task.ReplayRefused
			});
		}

		public override JobScheduler.JobState ProcessOrderResponse()
		{
			if (base.OrderMessage.Response == OrderResponse.Processed)
			{
				base.Task.ChangeStatus(BlackboardMessage_Evaluable.EvaluationStatus.Succeed);
			}
			else
			{
				base.Task.ChangeStatus(BlackboardMessage_Evaluable.EvaluationStatus.Failed);
			}
			return JobScheduler.JobState.Finished;
		}

		protected override bool NeedToSendOrder()
		{
			return true;
		}

		private GroundBattleReplayTask task;
	}
}
